package com.yaoyaozw.customer.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author darker
 * @date 2022/10/11 20:23
 */
public enum CustomerStoreTemplateEnum {

    /**
     * 客服消息书城活动模板
     */

    YANG_GUANG("YANG_GUANG", "5"),
    YUE_WEN("YUE_WEN", "1"),
    ZHANG_ZHONG_YUN("ZHANG_ZHONG_YUN", "1"),
    ZHANG_DU("ZHANG_DU", "1")

    ;

    private final String storeType;

    private final String templateId;

    CustomerStoreTemplateEnum(String storeType, String templateId) {
        this.storeType = storeType;
        this.templateId = templateId;
    }

    public String getStoreType() {
        return storeType;
    }

    public String getTemplateId() {
        return templateId;
    }

    public static String getTempId(String storeType) {
        if (StringUtils.isBlank(storeType)) {
            return null;
        }
        for (CustomerStoreTemplateEnum value : CustomerStoreTemplateEnum.values()) {
            if (storeType.contains(value.getStoreType())) {
                return value.getTemplateId();
            }
        }
        return null;
    }
}
