package com.yaoyaozw.customer.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.service.AccountOrderService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.service.impl.CrowdPackageServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

@Component
public class SchedulingTask {

    private final static Logger localLog = LoggerFactory.getLogger(SchedulingTask.class);


    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;

    @Autowired
    private CrowdPackageServiceImpl crowdPackageService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * 每10min扫描一次正常客服
     */
    @Scheduled(cron = "0 0/10 * * * *")
    public void publishCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);


    }


    /**
     * 每1min扫延时客服
     */
    @Scheduled(cron = "0 0/1 * * * *")
    public void publishDelayCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }




    /**
     * 每3h跑扫过期延时客服
     */
    @Scheduled(cron = "0 3 0/3 * * *")
    public void refreshExpiredDelayCustomer(){

        Calendar calendar = Calendar.getInstance();

        calendar.add(Calendar.MINUTE,-5);
        calendar.set(Calendar.SECOND,0);
        calendar.set(Calendar.MILLISECOND,0);

        customerDelayPublishService.updateExpiredCustomerDelayMessage(calendar.getTime());

    }


    /**
     * 从redis中更新人群包人数
     */
    @Scheduled(cron = "0 0/15 * * * ?")
    public void updateCrowdPackageNumFromRedis() {
        crowdPackageService.updateCrowdPackageNumFromRedis();
    }

    @Scheduled(cron = "0 0 1 * * ?")
    public void refreshCustomrMaterialSendNum() {
        List<CustomerGraphics> list = customerGraphicsService.list(new QueryWrapper<CustomerGraphics>().lt("post_time", new Date()));
        Map<Object, Object> customerCount = redisTemplate.opsForHash().entries("CUSTOMER_COUNT");
        Map<Long, Integer> map = new HashMap<>();
        for (Map.Entry<Object, Object> objectObjectEntry : customerCount.entrySet()) {
            map.put(Long.valueOf(objectObjectEntry.getKey().toString()), Integer.valueOf(objectObjectEntry.getValue().toString()));
        }

        List<CustomerGraphics> updateList = new ArrayList<>();
        for (CustomerGraphics customerGraphics : list) {
            CustomerGraphics entity = new CustomerGraphics();
            entity.setId(customerGraphics.getId());
            entity.setSendNum(map.getOrDefault(customerGraphics.getId(), 0));
            updateList.add(entity);
        }
        customerGraphicsService.updateBatchById(updateList);
    }
}
