package com.yaoyaozw.customer.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.CustomerFollowReply;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.event.AcquisitionExceptionEvent;
import com.yaoyaozw.customer.service.CustomerFollowReplyService;
import com.yaoyaozw.customer.service.CustomerFollowReplyService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Component
public class FollowReplyAcquisitionListener implements ApplicationListener<AcquisitionExceptionEvent> {


    @Resource
    private CustomerFollowReplyService customerFollowReplyService;
    @Resource
    private ReferralEntityService referralEntityService;


    @Override
    public void onApplicationEvent(AcquisitionExceptionEvent acquisitionExceptionEvent) {
        AcquisitionExceptionHandleParam source = acquisitionExceptionEvent.getSource();
        if (source == null) {
            return;
        }
        AuthorizerInfo authorizerInfo = source.getAuthorizerInfo();
        String fromPath = source.getFromPath();
        String toPath = source.getToPath();
        // 查询这个公众号延时客服用到了 fromPath 的地方，替换成 toPath
        List<CustomerFollowReply> allCustomerFollowReplyList = customerFollowReplyService.list(new QueryWrapper<CustomerFollowReply>().eq("app_id", authorizerInfo.getAppid()));

        // 过滤出发送链接是 fromPath 或者发送文本中的跳转链接包含 fromPath 的延时客服配置
        List<CustomerFollowReply> containsFromPathGraphicsList = allCustomerFollowReplyList.stream().filter(v -> (StringUtils.isNotBlank(v.getSourceUrl()) && v.getSourceUrl().contains(fromPath)) || (StringUtils.isNotBlank(v.getContent()) && v.getContent().contains(fromPath))).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(containsFromPathGraphicsList)) {
            log.info("公众号：{} 暂无使用获客链接：{} 的关回配置", authorizerInfo.getAppid(), fromPath);
            return;
        }
        List<Long> graphicsIds = containsFromPathGraphicsList.stream().map(CustomerFollowReply::getId).collect(Collectors.toList());
        List<ReferralEntity> relatedReferralEntityList = referralEntityService.list(new QueryWrapper<ReferralEntity>().in(ReferralEntity.COL_MATERIAL_GRAPHICS_ID, graphicsIds));

        List<CustomerFollowReply> updateGraphicsList = new ArrayList<>();
        List<ReferralEntity> updateReferralList = new ArrayList<>();

        // 替换 graphics 和 referral 中的 fromPath 为 toPath
        allCustomerFollowReplyList.forEach(item -> {
            boolean update = false;
            // 直跳链接
            if (StringUtils.isNotBlank(item.getSourceUrl()) && item.getSourceUrl().contains(fromPath)) {
                item.setSourceUrl(item.getSourceUrl().replaceAll(fromPath, toPath));
                update = true;
            }
            // 文本链接
            if (StringUtils.isNotBlank(item.getContent()) && item.getContent().contains(fromPath)) {
                item.setContent(item.getContent().replaceAll(fromPath, toPath));
                update = true;
            }
            if (update) {
                updateGraphicsList.add(item);
            }
        });
        relatedReferralEntityList.forEach(item -> {
            boolean update = false;
            // 直跳链接
            if (StringUtils.isNotBlank(item.getReferral()) && item.getReferral().contains(fromPath)) {
                item.setReferral(item.getReferral().replaceAll(fromPath, toPath));
                update = true;
            }
            // 文本链接
            if (StringUtils.isNotBlank(item.getTextContent()) && item.getTextContent().contains(fromPath)) {
                item.setTextContent(item.getTextContent().replaceAll(fromPath, toPath));
                update = true;
            }
            if (update) {
                updateReferralList.add(item);
            }
        });
        if (CollectionUtil.isNotEmpty(updateGraphicsList)) {
            customerFollowReplyService.updateBatchById(updateGraphicsList);
        }
        if (CollectionUtil.isNotEmpty(updateReferralList)) {
            referralEntityService.updateBatchById(updateReferralList);
        }

        // 刷新缓存数据
        customerFollowReplyService.putMaterialToRedis(authorizerInfo.getAppid(), null);
    }
}
