package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/18:47
 * @ClassName: AccountDistributeRecord
 * @Version: V3.2.0
 * @Description:
 */
@Data
@TableName("account_distribute_record")
public class AccountDistributeRecord implements Serializable {
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 原公众号id
     */
    @TableField("auth_id")
    private Long authId;

    @TableField("target_auth_id")
    private Long targetAuthId;
    /**
     * 分发的菜单名称
     */
    @TableField("function_name")
    private String functionName;
    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;
    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    private static final long serialVersionUID = 1L;

    public void saveDistribute(Long authId, Long targetId, List<String> functionName, Long createUser) {
        this.authId = authId;
        this.targetAuthId = targetId;
        this.functionName = groupName(functionName);
        this.createUser = createUser;
        this.gmtCreate = new Date();
        this.gmtModified = new Date();
    }

    private String groupName(List<String> functionName) {
        String name = "";
        for (String s : functionName) {
            switch (s) {
                case "1":
                    name += "关回, ";
                    break;
                case "2":
                    name += "关键词, ";
                    break;
                case "3":
                    name += "延时客服, ";
                    break;
                case "4":
                    name += "菜单管理, ";
                    break;
                default:
                    break;
            }
        }
        if (!name.isEmpty()) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

}
