package com.yaoyaozw.customer.service;

import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/28 19:01
 */
public interface CustomerServiceCommonService {

    /**
     * 得到从静态条件设置id列表
     *
     * @param expressList 表达列表
     * @return {@link List}<{@link Long}>
     */
    List<Long> getSetupIdListFromStaticCondition(List<String> expressList);

    /**
     * 获取存储列表
     *
     * @return {@link GenericsResult}<{@link CommonOptionResponseVO}>
     */
    GenericsResult<List<CommonOptionResponseVO>> getStoreList();

    /**
     * 把封面图片列表
     *
     * @return {@link GenericsResult}<{@link List}<{@link CommonOptionResponseVO}>>
     */
    GenericsResult<List<CommonOptionResponseVO>> getCoverPicList();
}
