package com.yaoyaozw.customer.components;

import cn.hutool.core.util.ObjectUtil;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2022/9/28 15:16
 */
@Component
public class CustomerServiceCommonAsyncComponent {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerServiceCommonAsyncComponent.class);


    @Async("myExecutor")
    public void addMatchUserIntoPackage(Long packageId, List<CrowdPackageUserVO> userList) {
        long startTime = System.currentTimeMillis();
        String packIdStr = packageId.toString();
        // 筛选当前不在这个人群包的用户
        List<CrowdPackageUserVO> userNotInPackageList = userList.stream()
                // 保留现在不在该人群包的用户
                .filter(item -> ObjectUtil.isNull(item.getInPackage()) || !item.getInPackage().contains(packIdStr))
                .peek(item -> {
                    if (ObjectUtil.isNull(item.getInPackage())) {
                        item.setInPackage(packIdStr);
                    } else {
                        // 将当前人群包拼在后面
                        item.setInPackage(item.getInPackage() + "," + packIdStr);
                    }
                }).collect(Collectors.toList());

        LOCAL_LOG.info("人群包ID: {} 新增用户 {}个", packIdStr, userNotInPackageList.size());


        long endTime = System.currentTimeMillis();
        LOCAL_LOG.info("异步添加符合条件用户人群包完成, 耗时: {}ms", endTime - startTime);
    }

    @Async("myExecutor")
    public void removeUnMatchUserFromPackage(Long packageId, List<CrowdPackageUserVO> userList) {
        long startTime = System.currentTimeMillis();
        String packIdStr = packageId.toString();
        // 筛选当前不在这个人群包的用户
        List<CrowdPackageUserVO> userRemoveFromPackList = userList.stream()
                // 移除现在在该人群包但不符合当前条件的用户
                .filter(item -> ObjectUtil.isNotNull(item.getInPackage()) && item.getInPackage().contains(packIdStr))
                .peek(item -> {
                    String removePackageStr = item.getInPackage().replace("," + packIdStr, "")
                            .replace(packIdStr + ",", "")
                            .replace(packIdStr, "");
                    item.setInPackage(removePackageStr);
                }).collect(Collectors.toList());

        LOCAL_LOG.info("人群包ID: {} 移除用户 {}个", packIdStr, userRemoveFromPackList.size());


        long endTime = System.currentTimeMillis();
        LOCAL_LOG.info("异步删除不符合条件用户所属人群包完成, 耗时: {}ms", endTime - startTime);
    }


}
