package com.yaoyaozw.customer.service.impl;

import com.yaoyaozw.customer.dto.DistributeDTO;
import com.yaoyaozw.customer.dto.MenuMainCopyDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplyCopyDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordCopyDTO;
import com.yaoyaozw.customer.entity.AccountDistributeRecord;
import com.yaoyaozw.customer.entity.MaterialMenuMain;
import com.yaoyaozw.customer.feigns.MenuFeignClient;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: Dwl
 * @Date: 2024/05/31/22:45
 * @ClassName: MyExecutorDistributeServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
@Service
public class MyExecutorDistributeServiceImpl implements MyExecutorDistributeService {
    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;
    @Autowired
    private CustomerKeywordService keywordService;
    @Autowired
    private CustomerFollowReplyService followReplyService;
    @Autowired
    private MenuFeignClient menuFeignClient;
    @Autowired
    private MaterialMenuConfigService materialMenuConfigService;
    @Autowired
    private MaterialMenuMainService materialMenuMainService;
    @Autowired
    private DistributeService distributeService;

    @Override
    public void myExecutorDistribute(DistributeDTO distributeDTO, Long userId, List<AccountDistributeRecord> distributeLogList, AuthInfoVO sourceAuth) {
        List<String> targetAppList = distributeDTO.getTargetAppList();
        //获取到当天再投的进行复用
        List<AuthInfoVO> targetAuthList = distributeDTO.getTargetAuthList();

        //删除目标公众号配置
        try {
            List<Long> authIds = distributeDTO.getAuthIds();
            materialMenuConfigService.removeById(authIds);
        } catch (Exception e) {
            log.error("Failed to delete the target public account configuration :{}", e.getMessage(), e);
        }


        List<String> targetApp = targetAuthList.stream().map(AuthInfoVO::getAppId).collect(Collectors.toList());
        List<Long> idList = targetAuthList.stream().map(AuthInfoVO::getId).collect(Collectors.toList());
        List<String> typeList = distributeDTO.getTypeList();

        try {
            for (String type : typeList) {
                switch (type) {
                    case "1":
                        //关回复用
                        try {
                            FollowReplyCopyDTO followReplyCopyDTO = new FollowReplyCopyDTO(sourceAuth, targetAuthList);
                            followReplyService.copy(followReplyCopyDTO);
                        } catch (Exception e) {
                            log.error("Off reply failed: {}", e.getMessage(), e);
                        }

                        break;
                    case "2":
                        //关键词复用
                        try {
                            CustomerKeywordCopyDTO customerKeywordCopyDTO = new CustomerKeywordCopyDTO();
                            customerKeywordCopyDTO.replace(sourceAuth, targetAuthList, targetAppList);
                            keywordService.copy(customerKeywordCopyDTO);
                        } catch (Exception e) {
                            log.error("Keyword reuse failure: {}", e.getMessage(), e);
                        }
                        break;
                    case "3":
                        //延时客服复用
                        try {
                            customerGraphicsDelayService.copy(sourceAuth.getAppId(), "", "", null, targetApp);
                        } catch (Exception e) {
                            log.error("Delayed customer service reuse failure: {}", e.getMessage(), e);
                        }
                        break;
                    case "4":
                        //菜单管理复用
                        try {
                            try {
                                List<String> appIds = targetAuthList.stream().map(AuthInfoVO::getAppId).collect(Collectors.toList());
                                List<MaterialMenuMain> materialMenuMainList = materialMenuMainService.getMaterialMenuMainVoInfo(appIds);
                                if (!materialMenuMainList.isEmpty()) {
                                    for (MaterialMenuMain menuMain : materialMenuMainList) {
                                        String appId = String.valueOf(menuMain.getAppId());
                                        menuFeignClient.removeMenu(menuMain.getId(), appId);
                                    }
                                }
                            } catch (Exception e) {
                                log.error("Failed to delete menu configuration: {}", e.getMessage(), e);
                            }
                            MenuMainCopyDTO menuMainCopyDTO = new MenuMainCopyDTO();
                            menuMainCopyDTO.addList(sourceAuth.getId(), idList);
                            menuFeignClient.copy(menuMainCopyDTO);
                        } catch (Exception e) {
                            log.error("Menu management reuse failure: {}", e.getMessage(), e);
                        }
                        break;
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            log.error("Distribution reuse exception：{}", e.getMessage(), e);
        }

        idList.forEach(c -> {
            AccountDistributeRecord distributeLog = new AccountDistributeRecord();
            distributeLog.saveDistribute(sourceAuth.getId(), c, typeList, userId);
            distributeLogList.add(distributeLog);
        });

        distributeService.saveBatch(distributeLogList);
    }
}
