package com.yaoyaozw.customer.feigns;

import com.yaoyaozw.customer.common.R;
import com.yaoyaozw.customer.entity.ReferralEntity;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 推荐装客户端
 *
 * @author Admin
 * @date 2022/10/09
 */
@FeignClient("referral-service-wgh")
public interface ReferralFeignClient {

    /**
     * 产品推荐
     *
     * @param referralEntity 推荐实体
     * @return {@link R}
     */
    @PostMapping("/getReferral")
    R productReferral(@RequestBody ReferralEntity referralEntity);

}
