package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 客户图片
 *
 * @author Admin
 * @date 2022/10/08
 */
@Data
@TableName(value = "customer_graphics")
public class CustomerGraphics implements Serializable {
    @TableId(value = "id", type = IdType.ID_WORKER)
    @Id
    private Long id;

    /**
     * 人群包id
     */
    @TableField(value = "pack_id")
    private Long packId;

    /**
     * 标题
     */
    @TableField(value = "name")
    private String name;

    /**
     * 类型 0-文本 1-图文
     */
    @TableField(value = "type")
    private String type;

    /**
     * 推广标题
     */
    @TableField(value = "extend_title")
    private String extendTitle;

    /**
     * 封面地址
     */
    @TableField(value = "cover_url")
    private String coverUrl;

    /**
     * 文本内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 发送时间
     */
    @TableField(value = "post_time")
    private Date postTime;

    /**
     * 创建人
     */
    @TableField(value = "create_user")
    private Long createUser;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create")
    private Date gmtCreate;

    /**
     * 更新人
     */
    @TableField(value = "modified_user")
    private Long modifiedUser;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified")
    private Date gmtModified;

    /**
     * 逻辑删除
     */
    @TableField(value = "is_deleted")
    @TableLogic
    private Boolean isDeleted;

    private static final long serialVersionUID = 1L;

    public static final String COL_ID = "id";

    public static final String COL_PACK_ID = "pack_id";

    public static final String COL_POST_TIME = "post_time";

    public static final String COL_CREATE_USER = "create_user";

    public static final String COL_GMT_CREATE = "gmt_create";

    public static final String COL_MODIFIED_USER = "modified_user";

    public static final String COL_GMT_MODIFIED = "gmt_modified";

    public static final String COL_IS_DELETED = "is_deleted";

    public void initOperateInfo(Long userId, Boolean isCreate) {
        Date now = new Date();
        if (isCreate) {
            this.createUser = userId;
            this.gmtCreate = now;
        }
        this.gmtModified = now;
        this.modifiedUser = userId;
    }
}