package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;

/**
 * @author darker
 * @date 2022/11/10 15:48
 */
@Data
@TableName("material_menu_main")
public class MaterialMenuMain implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ID_WORKER)
    @Id
    private Long id;

    /**
     * 公众号id
     */
    @TableField("auth_id")
    private Long authId;

    /**
     * 公众号appId
     */
    @TableField("app_id")
    private String appId;

    /**
     * 上级菜单id
     */
    @TableField("pid")
    private Long pid;

    /**
     * 手机系统 1-安卓 2-ios
     */
    @TableField("mobile_os")
    private Integer mobileOs;

    /**
     * 菜单标识
     */
    @TableField("menu_key")
    private String menuKey;

    /**
     * 菜单标识
     */
    @TableField("wechat_menu_id")
    private String wechatMenuId;

    /**
     * 菜单名称
     */
    @TableField("name")
    private String name;

    /**
     * 菜单点击类型（跳转\弹出）
     */
    @TableField("click_type")
    private Integer clickType;

    /**
     * 跳转链接类型 0-自定义 1-常用链接
     */
    @TableField("url_type")
    private Integer urlType;

    /**
     * 跳转值（书城常用链接的取值）
     */
    @TableField("skip_value")
    private String skipValue;

    /**
     * 跳转地址
     */
    @TableField("skip_url")
    private String skipUrl;

    /**
     * 资源配置主键id
     */
    @TableField("config_id")
    private String configId;

    /**
     * 状态
     */
    @TableField("status")
    private Integer status;

    /**
     * 菜单等级
     */
    @TableField("level")
    private Integer level;

    /**
     * 菜单排序
     */
    @TableField("sort")
    private Integer sort;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     * 创建人
     */
    @TableField(value = "gmt_create_user", fill = FieldFill.INSERT)
    private String gmtCreateUser;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    /**
     * 修改人
     */
    @TableField(value = "gmt_modified_user", fill = FieldFill.INSERT_UPDATE)
    private String gmtModifiedUser;

    public void clearDictConfig() {
        this.clickType = null;
        this.urlType = null;
        this.skipValue = null;
        this.skipUrl = null;
        this.configId = null;
    }

}

