package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 客户图形延迟
 *
 * @author Admin
 * @date 2022/10/13
 */
@Data
@TableName(value = "customer_graphics_delay")
public class CustomerGraphicsDelay implements Serializable {
    @TableId(value = "id", type = IdType.ID_WORKER)
    private Long id;

    /**
     * appid
     */
    @TableField(value = "app_id")
    private String appId;

    /**
     * 标题
     */
    @TableField(value = "name")
    private String name;

    /**
     * 类型
     */
    @TableField(value = "type")
    private String type;

    /**
     * 推广标题
     */
    @TableField(value = "extend_title")
    private String extendTitle;

    /**
     * 封面图地址
     */
    @TableField(value = "cover_url")
    private String coverUrl;

    /**
     * 文本内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 状态
     */
    @TableField(value = "send_status")
    private Integer sendStatus;

    /**
     * 原文链接
     */
    @TableField(value = "source_url")
    private String sourceUrl;

    /**
     * 是否支付
     */
    @TableField(value = "is_pay")
    private Integer isPay;

    /**
     * 发送序列
     */
    @TableField(value = "post_sort")
    private Integer postSort;

    /**
     * 间隔时间
     */
    @TableField(value = "time_interval")
    private Long timeInterval;

    /**
     * 创建人
     */
    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     * 更新人
     */
    @TableField(value = "modified_user", fill = FieldFill.INSERT_UPDATE)
    private Long modifiedUser;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    /**
     * 逻辑删除
     */
    @TableField(value = "is_deleted")
    @TableLogic
    private Integer isDeleted;

    @TableField(exist = false)
    private List<ReferralEntity> belongReferralList;

    @TableField(exist = false)
    private AuthorizerInfo authorizerInfo;

    private static final long serialVersionUID = 1L;

    public static final String COL_ID = "id";

    public static final String COL_APP_ID = "app_id";

    public static final String COL_POST_SORT = "post_sort";

    public static final String COL_TIME_INTERVAL = "time_interval";

    public static final String COL_CREATE_USER = "create_user";

    public static final String COL_GMT_CREATE = "gmt_create";

    public static final String COL_MODIFIED_USER = "modified_user";

    public static final String COL_GMT_MODIFIED = "gmt_modified";

    public static final String COL_IS_DELETED = "is_deleted";

    public void initOperateInfo(Long userId, Boolean isCreate) {
        Date now = new Date();
        if (isCreate) {
            this.createUser = userId;
            this.gmtCreate = now;
        }
        this.gmtModified = now;
        this.modifiedUser = userId;
    }

}