package com.yaoyaozw.customer.service.impl;


import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.mapper.RegisterUserEntityMapper;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.service.RegisterUserEntityService;

import java.util.*;



@Service
public class RegisterUserEntityServiceImpl extends ServiceImpl<RegisterUserEntityMapper, RegisterUserEntity> implements RegisterUserEntityService{


    @Override
    public List<CrowdPackageUserVO> getUserMatchDynamicExpress(List<String> dynamicExpressList, String openId) {

        return baseMapper.getUserMatchDynamicExpress(dynamicExpressList, openId);

    }

    @Override
    public List<Long> getAccountIdListFromPackage(Long packageId) {

        return baseMapper.getAuthListFromPackage(packageId);
    }

    @Override
    public List<CrowdPackageUserVO> getCurrentInPackUserList(Long packageId,Boolean isLeftJoin) {

        if (isLeftJoin!=null&&isLeftJoin){

            return baseMapper.getCurrentInPackUserList(packageId);

        }else {

            return baseMapper.getCurrentInPackUserListWithoutAccountId(packageId);
        }
    }

    @Override
    public List<RegisterUserEntity> getAllExpiredDelayPublish(Date requestDate){

        return baseMapper.findAllExpiredDelayPublish(requestDate);
    }
}
