package com.yaoyaozw.customer.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 人群包条件匹配
 *
 * @author darker
 * @date 2022/09/21
 */
@Data
public class CrowdPackageConditionMatch implements Serializable {
    /**
     * 主键
     */
    @Id
    @TableId("id")
    private Long id;

    /**
     * 人群包ID
     */
    @TableField("package_id")
    private Long packageId;

    /**
     * 条件表主键ID
     */
    @TableField("condition_id")
    private Long conditionId;

    /**
     * 条件运算符
     */
    @TableField("condition_operator")
    private String conditionOperator;

    /**
     * 运算值
     */
    @TableField("operator_value")
    private String operatorValue;

    /**
     * 条件表达式
     */
    @TableField("operator_expression")
    private String operatorExpression;

    /**
     * 条件描述
     */
    @TableField("operator_description")
    private String operatorDescription;

    /**
     * 是否是静态条件
     */
    @TableField("is_static")
    private Integer isStatic;

    private static final long serialVersionUID = 1L;
}

