package com.yaoyaozw.customer.dto;

import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/17:17
 * @ClassName: DistributeDTO
 * @Version: V3.2.0
 * @Description:
 */
@Data
public class DistributeDTO {
    private String appId;
    private List<String> targetAppList;
    private AuthInfoVO sourceAuth;
    private List<AuthInfoVO> targetAuthList;
    private List<String> typeList;


    public List<String> getAccountId() {
        if (!this.targetAuthList.isEmpty()) {
            return targetAuthList.stream().map(AuthInfoVO::getAccountId).collect(Collectors.toList());
        }
        return null;
    }

    public List<AuthInfoVO> filterInfo(List<Long> channelIds) {
        if (!this.targetAuthList.isEmpty()) {
            return this.getTargetAuthList().stream().filter(item -> channelIds.contains(Long.valueOf(item.getAccountId()))).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    public List<Long> getAuthIds() {
        return this.getTargetAuthList().stream().map(AuthInfoVO::getId).collect(Collectors.toList());
    }

    public Integer getTargetAuthListSize() {
        return this.targetAuthList.size();
    }

    public List<String> appIds() {
        return this.getTargetAuthList().stream().map(AuthInfoVO::getAppId).collect(Collectors.toList());
    }
}
