package com.yaoyaozw.customer.scheduling;

import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;

@Component
public class SchedulingTask {

    @Autowired
    private AccountOrderService accountOrderService;

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;


    /**
     * 拉取付费订单(每15min一次)
     */
    public void retrieveOrderData(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    /**
     * 更新付费用户近一月平均充值(每天一次）
     */
    public void retrieveMonthOrder(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.calculateAvgMonth(integrationRequestDTO);

    }


    /**
     * 每10min扫描一次正常客服
     */
    public void publishCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);


    }


    /**
     * 每1min扫延时客服
     */
    public void publishDelayCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }
}
