package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Calendar;

/**
 * @author wgh
 * @date 2022/10/10 20:04
 */
@RestController
@RequestMapping("/customer-service/test")
public class TestController {

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @GetMapping("/CustomerTest")
    public void test(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,20);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);
    }
}
