package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.entity.CrowdPackageConditionMatch;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.mapper.MaterialCrowdConditionMatchMapper;
import com.yaoyaozw.customer.service.CrowdPackageConditionMatchService;
import com.yaoyaozw.customer.service.CustomerServiceCommonService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2022/9/21 15:09
 */
@Service
public class CrowdPackageConditionMatchServiceImpl extends ServiceImpl<MaterialCrowdConditionMatchMapper, CrowdPackageConditionMatch> implements CrowdPackageConditionMatchService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CrowdPackageConditionMatchServiceImpl.class);

    @Autowired
    private CustomerServiceCommonService commonService;
    @Autowired
    private RegisterUserEntityService userEntityService;

    @Override
    public List<CrowdPackageUserVO> getUserListFromPackage(Long packageId) {
        long startTime = System.currentTimeMillis();

        // 获取人群包下的条件
        List<CrowdPackageConditionMatch> packageConditionList = super.list(new QueryWrapper<CrowdPackageConditionMatch>().eq("package_id", packageId));
        List<String> staticConditionList = packageConditionList.stream().filter(item -> CrowdPackageCommonConstant.STATIC_CONDITION.equals(item.getIsStatic())).map(CrowdPackageConditionMatch::getOperatorExpression).collect(Collectors.toList());
        List<String> nonStaticConditionList = packageConditionList.stream().filter(item -> CrowdPackageCommonConstant.NON_STATIC_CONDITION.equals(item.getIsStatic())).map(CrowdPackageConditionMatch::getOperatorExpression).collect(Collectors.toList());
        LOCAL_LOG.info("静态条件: {}条, 动态条件: {}条", staticConditionList.size(), nonStaticConditionList.size());
        long getConditionTime = System.currentTimeMillis();
        LOCAL_LOG.info("获取条件列表耗时 {}ms", getConditionTime - startTime);

        // 根据静态条件获取setupId
        List<Long> setupIdList = commonService.getSetupIdListFromStaticCondition(staticConditionList);
        long getSetupIdTime = System.currentTimeMillis();
        LOCAL_LOG.info("获取SetupId列表耗时 {}ms, setupId列表长度: {}", getSetupIdTime - getConditionTime, setupIdList.size());

        // 根据动态条件获取用户列表
        List<CrowdPackageUserVO> userList = userEntityService.getUserMatchDynamicExpress(nonStaticConditionList);
        long dynamicUserTime = System.currentTimeMillis();
        LOCAL_LOG.info("获取SetupId列表符合动态条件的用户耗时 {}ms, 符合动态条件的用户: {}个", dynamicUserTime - getSetupIdTime, userList.size());

        // 筛选所属setupId在列表中的用户
        if (CollectionUtil.isNotEmpty(setupIdList)) {
            userList = userList.stream().filter(item -> setupIdList.contains(item.getSetupId())).collect(Collectors.toList());
        }
        long allUserTime = System.currentTimeMillis();
        LOCAL_LOG.info("获取符合全部条件的用户耗时: {}ms, 符合全部条件的用户: {}个", allUserTime - dynamicUserTime, userList.size());

        return userList;
    }
}
