package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageSaveDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/16 12:03
 */
public interface CrowdPackageService extends IService<CrowdPackage> {
    /**
     * 插入人群包
     *
     * @param saveDto 保存dto
     * @return {@link BaseResult}
     */
    BaseResult insertCrowdPackage(CrowdPackageSaveDTO saveDto);

    /**
     * 人群更新包
     *
     * @param saveDto 保存dto
     * @return {@link BaseResult}
     */
    BaseResult updateCrowdPackage(CrowdPackageSaveDTO saveDto);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageListVO}>>
     */
    GenericsResult<List<CrowdPackageListVO>> pageList(CrowdPackageQueryDTO queryDto);

    /**
     * 删除群包
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCrowdPackage(Long id);
}
