package com.yaoyaozw.customer.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 人群包装条件
 *
 * @author darker
 * @date 2022/09/20
 */
@Data
@TableName("crowd_package_condition")
public class CrowdPackageCondition implements Serializable {
    /**
     * 主键ID
     */
    @TableId("id")
    @Id
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 条件值
     */
    @TableField("condition_key")
    private String conditionKey;

    /**
     * 条件名称
     */
    @TableField("condition_name")
    private String conditionName;

    /**
     * 条件类型
     */
    @TableField("condition_type")
    private String conditionType;

    /**
     * 条件选项的前端类型
     */
    @TableField("front_type")
    private String frontType;

    /**
     * 是否静态属性
     */
    @TableField("is_static")
    private Integer isStatic;

    /**
     * 选项所在数据库服务器
     */
    @TableField("source_base_service")
    private String sourceBaseService;

    /**
     * 选项所在表
     */
    @TableField("source_table")
    private String sourceTable;

    /**
     * 选项的key值对应字段
     */
    @TableField("key_column")
    private String keyColumn;

    /**
     * 选项的name对应字段
     */
    @TableField("name_column")
    private String nameColumn;

    /**
     * 选项查询时的额外条件
     */
    @TableField("sql_factor")
    private String sqlFactor;

    private static final long serialVersionUID = 1L;
}

