package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageTextSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.service.CustomerGraphicsTextService;
import com.yaoyaozw.customer.vo.customer.CustomerMessageTextDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "客服消息接口-文本")
@RestController
@RequestMapping("/customer-service/message/text")
public class CustomerMessageTextController {

    @Autowired
    private CustomerGraphicsTextService textService;

    @ApiOperation("新增客服主体")
    @PostMapping("/insertCustomerMessage")
    @OperateLog(module = "客服消息-文本", desc = "新增文本客服消息")
    public GenericsResult<String> insertCustomerMessage(@RequestBody CustomerMessageTextSaveDTO saveDto) {
        return textService.insertCustomerMessage(saveDto);
    }

    @ApiOperation("新增客服内容")
    @PostMapping("/insertCustomerContent")
    @OperateLog(module = "客服消息-文本", desc = "新增文本客服消息子素材")
    public GenericsResult<CustomerMessageTextDetailVO> insertCustomerContent(@RequestBody CustomerReferralDTO referralDto) {
        return textService.insertCustomerContent(referralDto);
    }

    @ApiOperation("获取文本客服详情")
    @GetMapping("/detail/{id}")
    public GenericsResult<CustomerMessageTextDetailVO> getCustomerTextDetail(@PathVariable("id") Long id) {
        return textService.getCustomerTextDetail(id);
    }

    @ApiOperation("删除单条文本内容")
    @GetMapping("/removeCustomerContent/{contentId}")
    @OperateLog(module = "客服消息-文本", desc = "删除文本客服消息子素材")
    public GenericsResult<CustomerMessageTextDetailVO> removeCustomerContent(@PathVariable("contentId") Long contentId) {
        return textService.removeCustomerContent(contentId);
    }



}
