package com.yaoyaozw.customer.utils;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
public class HttpClientUtil {

    static PoolingHttpClientConnectionManager poolingClient = null;


    /**
     * 得到http客户端
     *
     * @param timeout 超时
     * @return {@link CloseableHttpClient}
     */
    public static CloseableHttpClient getHttpClient(int timeout) {
        // 设置连接超时时间
        int connectTimeout = 2 * 1000;
        int socketTimeout = timeout * 1000;

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(connectTimeout)
                .setSocketTimeout(socketTimeout).build();

        //因为服务端断开连接，但并没有通知客户端，导致下次请求该服务时httpclient继续使用该连接导致报错。
        ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy() {
            @Override
            public long getKeepAliveDuration(HttpResponse httpResponse,
                                             HttpContext httpContext) {
                return 10000L;
            }
        };

        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager(poolingClient);
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler());
        httpClientBuilder.setKeepAliveStrategy(connectionKeepAliveStrategy);

        return httpClientBuilder.build();
    }

    public static String doPostJson(String url, String json, Map<String, String> param) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            //创建post方法连接实例，在post方法中传入待连接地址
            HttpPost httpPost = new HttpPost(uri);
            // 创建请求内容
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return resultString;
    }

    public static String uploadFile(String url, MultipartFile file, Map<String, String> param) {
        String result = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            //创建post方法连接实例，在post方法中传入待连接地址
            HttpPost httpPost = new HttpPost(uri);
            //HttpMultipartMode.RFC6532参数的设定是为避免文件名为中文时乱码
            MultipartEntityBuilder entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
//            httpPost.addHeader("header1", "111");//头部放文件上传的head可自定义
            entity.addBinaryBody("media", file.getBytes(), ContentType.MULTIPART_FORM_DATA, file.getOriginalFilename());
            HttpEntity httpEntity = entity.build();
            httpPost.setEntity(httpEntity);
            // 执行提交
            response = httpClient.execute(httpPost);
            //接收调用外部接口返回的内容
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                // 返回的内容都在content中
                InputStream content = responseEntity.getContent();
                // 定义BufferedReader输入流来读取URL的响应
                BufferedReader in = new BufferedReader(new InputStreamReader(content));
                String line;
                while ((line = in.readLine()) != null) {
                    result += line;
                }
            }
        } catch (Exception e) {
            log.error("上传文件失败：", e);
        } finally {//处理结束后关闭httpclient的链接
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String uploadFileByte(String url, byte[] data, Map<String, String> param, String fileSuffix) {
        String result = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            //创建post方法连接实例，在post方法中传入待连接地址
            HttpPost httpPost = new HttpPost(uri);
            //HttpMultipartMode.RFC6532参数的设定是为避免文件名为中文时乱码
            MultipartEntityBuilder entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
//            httpPost.addHeader("header1", "111");//头部放文件上传的head可自定义
            entity.addBinaryBody("media", data, ContentType.MULTIPART_FORM_DATA, UUID.randomUUID() + "." + fileSuffix);
            HttpEntity httpEntity = entity.build();
            httpPost.setEntity(httpEntity);
            // 执行提交
            response = httpClient.execute(httpPost);
            //接收调用外部接口返回的内容
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                // 返回的内容都在content中
                InputStream content = responseEntity.getContent();
                // 定义BufferedReader输入流来读取URL的响应
                BufferedReader in = new BufferedReader(new InputStreamReader(content));
                String line;
                while ((line = in.readLine()) != null) {
                    result += line;
                }
            }
        } catch (Exception e) {
            log.error("上传文件失败：", e);
        } finally {//处理结束后关闭httpclient的链接
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static byte[] readInputStream(String sUrl) {
        try {
            URL url = new URL(sUrl);
            URLConnection connection = url.openConnection();
            InputStream inStream = connection.getInputStream();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
            return outStream.toByteArray();
        } catch (Exception e) {
            log.info("获取网络图片失败");
            throw new RuntimeException(e.getMessage());
        }
    }

    /**
     * 根据地址获得数据的字节流
     *
     * @param strUrl 网络连接地址
     * @return
     */
    public static byte[] getImageFromNetByUrl(String strUrl) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5 * 1000);
            InputStream inStream = conn.getInputStream();
            byte[] btImg = readInputStream(inStream);
            return btImg;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 从输入流中获取数据
     *
     * @param inStream 输入流
     * @return
     * @throws Exception
     */
    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        int len;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }


    public static String doGet(String url, Map<String, String> param) {

        // 创建Httpclient对象
        CloseableHttpClient httpclient = HttpClients.createDefault();

        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            log.info("请求uri：{}", uri.toString());
            // 创建http GET请求
            HttpGet httpGet = new HttpGet(uri);

            // 执行请求
            response = httpclient.execute(httpGet);
            // 判断返回状态是否为200
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doGet(String url) {

        // 创建Httpclient对象
        CloseableHttpClient httpClient = getHttpClient(4);

        String resultString = "";
        CloseableHttpResponse response = null;
        // 创建http GET请求
        HttpGet httpGet = new HttpGet(url);
        try {
            // 执行请求
            response = httpClient.execute(httpGet);
            // 判断返回状态是否为200
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (ConnectTimeoutException | SocketTimeoutException e) {
            //再重试一遍
            return doRepeat(httpGet);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("HttpClientUtil url: " + url + "+ error:{}", e);
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
                log.error("HttpClientUtil url: " + url + "+ error:{}", e);
            }
        }
        return resultString;
    }

    public static String doPostToTpm(String url, Map<String, Object> param) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = getHttpClient(1000);
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            StringBuffer sb = new StringBuffer();
            sb.append(url).append("?appKey=").append(param.get("appKey"))
                    .append("&messageType=").append(param.get("messageType"))
                    .append("&sign=").append(param.get("sign"))
                    .append("&timestamp=").append(param.get("timestamp"));
            url = sb.toString();
            HttpPost httpPost = new HttpPost(url);
            log.info("url : " + url);

            //添加body
            ByteArrayEntity entity = null;
            try {
                entity = new ByteArrayEntity(JSON.toJSONString(JSON.toJSONString(param)).getBytes("UTF-8"));
                entity.setContentType("application/json");
            } catch (UnsupportedEncodingException e) {
                log.error("向服务器承保接口发起http请求,封装请求body时出现异常", e);
                throw new RuntimeException("向服务器承保接口发起http请求,封装请求body时出现异常", e);
            }
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            log.error("doPostToTpm error: {} ", e.getMessage());
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return resultString;
    }

    public static String doPost(String url) {
        return doPost(url, null);
    }

    public static String doPost(String url, Map<String, String> param) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建参数列表
            if (param != null) {
                List<NameValuePair> paramList = new ArrayList<>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                // 模拟表单
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity(entity);
            }
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return resultString;
    }

    public static String doPostJson(String url, String json) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建请求内容
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return resultString;
    }


    /**
     * 做重复
     *
     * @param request 请求
     * @return {@link String}
     */
    private static String doRepeat(HttpRequestBase request) {
        CloseableHttpClient httpClient = getHttpClient(6);
        HttpResponse response = null;
        try {
            response = httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("重发，接口请求失败，httpcode="
                        + response.getStatusLine().getStatusCode() + "; url="
                        + request.getURI());
                return null;
            }

            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            log.error("重发，调用API错误， url：" + request.getURI(), e);
            return null;
        } finally {
            close(response, httpClient);
        }
    }

    private static void close(HttpResponse response, CloseableHttpClient httpClient) {
        if (response != null) {
            try {
                EntityUtils.consume(response.getEntity());
            } catch (IOException e) {
                log.error("response close error: {}", e.getMessage());
            }
        }
    }


    public static String doPostToCustomerTpm(String url, Map<String, Object> param) {
        // 创建Httpclient对象
        CloseableHttpClient httpClient = getHttpClient(1000);
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            // 创建Http Post请求
            StringBuffer sb = new StringBuffer();
            sb.append(url).append("?appKey=").append(param.get("appKey"))
                    .append("&messageType=").append(param.get("messageType"))
                    .append("&sign=").append(param.get("sign"))
                    .append("&timestamp=").append(param.get("timestamp"))
                    .append("&customerCode=").append(param.get("customerCode"));
            url = sb.toString();
            HttpPost httpPost = new HttpPost(url);
            log.info("url : " + url);

            //添加body
            ByteArrayEntity entity = null;
            try {
                entity = new ByteArrayEntity(JSON.toJSONString(JSON.toJSONString(param)).getBytes("UTF-8"));
                entity.setContentType("application/json");
            } catch (UnsupportedEncodingException e) {
                log.error("向服务器承保接口发起http请求,封装请求body时出现异常", e);
                throw new RuntimeException("向服务器承保接口发起http请求,封装请求body时出现异常", e);
            }
            httpPost.setEntity(entity);
            // 执行http请求
            response = httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "utf-8");
        } catch (Exception e) {
            log.error("doPostToTpm error: {} ", e.getMessage());
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return resultString;
    }
    public static String doPostFromDate(String url, Map<String, String> data, Map<String, String> param) {
        StringBuilder result = new StringBuilder();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            // 创建uri
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            //创建post方法连接实例，在post方法中传入待连接地址
            HttpPost httpPost = new HttpPost(uri);
            //HttpMultipartMode.RFC6532参数的设定是为避免文件名为中文时乱码
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
//            httpPost.addHeader("header1", "111");//头部放文件上传的head可自定义
            for (Map.Entry<String, String> stringStringEntry : data.entrySet()) {
                entity.addTextBody(stringStringEntry.getKey(),stringStringEntry.getValue());
            }
            HttpEntity httpEntity = entity.build();
            httpPost.setEntity(httpEntity);
            // 执行提交
            response = httpClient.execute(httpPost);
            //接收调用外部接口返回的内容
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                // 返回的内容都在content中
                InputStream content = responseEntity.getContent();
                // 定义BufferedReader输入流来读取URL的响应
                BufferedReader in = new BufferedReader(new InputStreamReader(content));
                String line;
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
        } catch (Exception e) {
            log.error("上传文件失败：", e);
        } finally {//处理结束后关闭httpclient的链接
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.toString();
    }
}
