package com.yaoyaozw.customer.controller;

import cn.hutool.core.util.ObjectUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.constants.RabbitCommonNameConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.service.AccountOrderService;
import com.yaoyaozw.customer.service.CustomerDelayPublishService;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wgh
 * @date 2022/10/10 20:04
 */
@Slf4j
@RestController
@RequestMapping("/customer-service/test")
public class TestController {

    private final static String STORE_ENTITY_REDIS_KEY = "STORE_NAME_MAP";

    @Autowired
    private CustomerGraphicsService customerGraphicsService;
    @Autowired
    private AccountOrderService accountOrderService;
    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;

    @GetMapping("/CustomerTest")
    public void test(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,16);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);
    }

    @GetMapping("/CustomerDelayTest")
    public void delayTest(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,17);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }

    @GetMapping("/payTest")
    public void payTest(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,12);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    @GetMapping("/putRedisStore")
    public void redisStore() {
        List<AuthInfoVO> allStoreList = kanbanCommonMapper.getAllStoreList();
        Map<String, String> storeMap = allStoreList.stream().collect(Collectors.toMap(AuthInfoVO::getStoreType, AuthInfoVO::getStoreTypeName));
        redisTemplate.opsForHash().putAll(STORE_ENTITY_REDIS_KEY, storeMap);

    }

}
