package com.yaoyaozw.customer.exception;

import cn.hutool.core.text.StrBuilder;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.utils.LogUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 10626
 */
@Slf4j
@RestControllerAdvice(annotations = RestController.class)
public class ExceptionControllerAdvice {

    @ExceptionHandler(value = MethodArgumentNotValidException.class)
    public BaseResult handleValidException(MethodArgumentNotValidException e) {
        log.error("数据校验出现问题{}，异常类型：{}", e.getMessage(), e.getClass());
        BindingResult bindingResult = e.getBindingResult();
        // 将校验信息直接拼接进行返回
        StrBuilder strBuilder = new StrBuilder();
        for (FieldError fieldError : bindingResult.getFieldErrors()) {
            strBuilder.append(fieldError.getDefaultMessage()).append("\n");
        }
        return new BaseResult().error(strBuilder.toString());
    }

    @ExceptionHandler(value = AopCommonException.class)
    public BaseResult aopCommonException(AopCommonException e) {
        String msg = LogUtils.getStackTraceInfo(e);
        log.error("AOP异常-> {}", msg);
        return new BaseResult().error(e.getMessage());
    }

    @ExceptionHandler(value = BaseException.class)
    public BaseResult baseException(BaseException e) {
        String msg = LogUtils.getStackTraceInfo(e);
        log.error("系统出现异常{}", msg);
        return new BaseResult().error(e.getMessage());
    }

    @ExceptionHandler(value = Exception.class)
    public BaseResult handleException(Exception e) {
        log.error("错误：{}", LogUtils.getStackTraceInfo(e));
        e.printStackTrace();
        return new BaseResult().error(e.getMessage());
    }
}
