package com.yaoyaozw.customer.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.yaoyaozw.customer.constants.ApiResultConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class R {
	@ApiModelProperty(value = "是否成功")
	private Boolean success;

	@ApiModelProperty(value = "返回码")
	private Integer code;

	@ApiModelProperty(value = "返回消息")
	private String message;

	@ApiModelProperty(value = "返回数据")
	private Map<String, Object> data = new HashMap<String, Object>();

	//把构造方法私有
	private R() {}

	//成功静态方法
	public static R ok() {
		R r = new R();
		r.setSuccess(true);
		r.setCode(ApiResultConstant.SUCCESS_CODE);
		r.setMessage("成功");
		return r;
	}
	//成功静态方法
	public static R copyError() {
		R r = new R();
		r.setSuccess(true);
		r.setCode(ApiResultConstant.SUCCESS_CODE);
		r.setMessage("成功");
		return r;
	}

	//失败静态方法
	public static R error() {
		R r = new R();
		r.setSuccess(false);
		r.setCode(ApiResultConstant.FAILURE_CODE);
		r.setMessage("请求失败，请先登录");
		return r;
	}
	//利用fastjson进行逆转
	public <T> T getData(String key, TypeReference<T> typeReference){
		//默认是map
		Object d = data.get(key);
		String s = JSON.toJSONString(d);
		T t = JSON.parseObject(s, typeReference);
		return t;
	}

	//利用fastjson进行逆转
	public <T> T getData(TypeReference<T> typeReference){
		//默认是map
		Object d = data.get("data");
		String s = JSON.toJSONString(d);
		T t = JSON.parseObject(s, typeReference);
		return t;
	}
	//失败静态方法
	public static R error(String message) {
		R r = new R();
		r.setSuccess(false);
		r.setCode(ApiResultConstant.FAILURE_CODE);
		r.setMessage(message);
		return r;
	}
	//失败静态方法
	public static R loginError() {
		R r = new R();
		r.setSuccess(false);
		r.setCode(ApiResultConstant.FAILURE_CODE);
		r.setMessage("登录失败，请重新再试");
		return r;
	}

	public R success(Boolean success){
		this.setSuccess(success);
		return this;
	}

	public R message(String message){
		this.setMessage(message);
		return this;
	}

	public R code(Integer code){
		this.setCode(code);
		return this;
	}

	public R data(String key, Object value){
		this.data.put(key, value);
		return this;
	}

	public R data(Map<String, Object> map){
		this.setData(map);
		return this;
	}
}
